<?php $__env->startSection('title', 'Comprar Cartones'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-[calc(100vh-140px)] flex items-center justify-center p-4">
    <div class="max-w-4xl w-full">
        
        <!-- Mensaje de reembolso -->
        <?php if(session('reembolso')): ?>
            <div class="mb-4 glass-effect rounded-xl p-4 border border-green-500/50 bg-gradient-to-r from-green-500/20 to-emerald-500/20 animate-pulse">
                <div class="flex items-center gap-3">
                    <div class="w-12 h-12 rounded-full bg-green-500/30 flex items-center justify-center">
                        <span class="text-2xl">💰</span>
                    </div>
                    <div>
                        <p class="text-green-400 font-bold text-lg">¡Reembolso recibido!</p>
                        <p class="text-white text-xl font-black">+$<?php echo e(number_format(session('reembolso'), 0)); ?></p>
                        <p class="text-gray-400 text-xs">El moderador reinició el sorteo y se devolvió tu apuesta</p>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Info del jugador logueado -->
        <div class="mb-6">
            <div class="glass-effect rounded-2xl p-4 border border-cyan-500/30 bg-gradient-to-r from-cyan-500/10 to-blue-500/10">
                <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-3">
                    <div class="flex items-center gap-3">
                        <?php if($user->avatar): ?>
                            <img src="<?php echo e($user->avatar); ?>" alt="Avatar" class="w-10 h-10 sm:w-12 sm:h-12 rounded-full border-2 border-cyan-500/50">
                        <?php else: ?>
                            <div class="w-10 h-10 sm:w-12 sm:h-12 rounded-full bg-gradient-to-br from-cyan-400 to-blue-500 flex items-center justify-center shadow-lg shadow-cyan-500/30">
                                <span class="text-xl sm:text-2xl">👤</span>
                            </div>
                        <?php endif; ?>
                        <div>
                            <p class="text-sm sm:text-base font-semibold text-white"><?php echo e($user->name); ?></p>
                            <p class="text-2xl sm:text-3xl font-black text-cyan-400">$<?php echo e(number_format($balance, 0)); ?></p>
                        </div>
                    </div>
                    <div class="flex items-center gap-2 w-full sm:w-auto">
                        <a href="<?php echo e(route('bingo.recargar')); ?>" 
                           title="Agregar saldo a tu cuenta con tarjeta, PayPal o Bitcoin"
                           aria-label="Recargar saldo"
                           class="flex-1 sm:flex-none px-4 py-2 rounded-lg text-sm font-bold bg-gradient-to-r from-green-500 to-emerald-600 text-white hover:from-green-400 hover:to-emerald-500 transition-all shadow-lg shadow-green-500/30 flex items-center justify-center gap-2">
                            <span>💳</span> Recargar
                        </a>
                        <form action="<?php echo e(route('logout')); ?>" method="POST" class="inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit" 
                                    class="px-3 py-2 rounded-lg text-xs font-semibold bg-gray-700 text-gray-300 hover:bg-red-600 hover:text-white transition-colors" 
                                    title="Cerrar sesión"
                                    aria-label="Cerrar sesión">
                                🚪
                            </button>
                        </form>
                    </div>
                </div>
                <?php if(count($ganancias) > 0): ?>
                    <div class="mt-3 pt-3 border-t border-cyan-500/20">
                        <p class="text-xs text-gray-400 mb-2">Últimas ganancias:</p>
                        <div class="flex flex-wrap gap-2">
                            <?php $__currentLoopData = array_slice(array_reverse($ganancias), 0, 3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ganancia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="px-2 py-1 rounded-full text-xs font-semibold <?php echo e($ganancia['tipo'] === 'BINGO' ? 'bg-yellow-500/20 text-yellow-400' : 'bg-green-500/20 text-green-400'); ?>">
                                    <?php echo e($ganancia['tipo']); ?>: +$<?php echo e(number_format($ganancia['monto'], 0)); ?>

                                </span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="text-center mb-8">
            <div class="inline-block rounded-2xl p-1 mb-4">
                <div class="glass-effect rounded-2xl px-10 py-6 border border-yellow-500/30 bg-gradient-to-br from-yellow-500/10 to-orange-500/10">
                    <p class="text-sm text-yellow-400/80 uppercase tracking-widest mb-2 font-semibold">🏆 Acumulado</p>
                    <p class="text-5xl md:text-7xl font-black text-yellow-400">
                        $<?php echo e(number_format($juegoActivo->acumulado, 0)); ?>

                    </p>
                </div>
            </div>
            
            <h2 class="text-2xl md:text-3xl font-bold text-white mb-2">¡Compra tus Cartones!</h2>
            <p class="text-gray-400">Selecciona la cantidad de cartones que deseas</p>
            
            <div class="flex justify-center gap-6 mt-4 text-sm">
                <div class="flex items-center gap-2">
                    <div class="w-3 h-3 rounded-full bg-green-500"></div>
                    <span class="text-gray-400">Línea: <span class="text-green-400 font-semibold">$<?php echo e(number_format($juegoActivo->premio_linea, 0)); ?></span></span>
                </div>
                <div class="flex items-center gap-2">
                    <div class="w-3 h-3 rounded-full bg-purple-500"></div>
                    <span class="text-gray-400">Bingo: <span class="text-purple-400 font-semibold">$<?php echo e(number_format($juegoActivo->premio_bingo, 0)); ?></span></span>
                </div>
            </div>
        </div>

        <div class="glass-effect rounded-3xl p-6 md:p-8">
            <form action="<?php echo e(route('bingo.comprar', $juegoActivo)); ?>" method="POST" id="comprar-form">
                <?php echo csrf_field(); ?>

                <div class="mb-8" x-data="{ cantidad: '1' }">
                    <label class="block text-sm font-semibold text-yellow-400 mb-4 uppercase tracking-wider">
                        Cantidad de Cartones
                    </label>
                    <div class="grid grid-cols-2 sm:grid-cols-4 gap-2 sm:gap-3">
                        <?php for($i = 1; $i <= 4; $i++): ?>
                            <label class="relative cursor-pointer group">
                                <input type="radio" name="cantidad" value="<?php echo e($i); ?>" class="sr-only" <?php echo e($i === 1 ? 'checked' : ''); ?> x-model="cantidad">
                                <div class="rounded-xl p-3 sm:p-4 text-center border-2 transition-all duration-200 transform"
                                     :class="cantidad == '<?php echo e($i); ?>' 
                                         ? 'border-green-500 bg-gradient-to-br from-green-500/30 to-emerald-600/20 shadow-lg shadow-green-500/30 scale-105' 
                                         : 'border-gray-600 bg-gray-800/50 hover:bg-gray-700/50 hover:border-gray-500 hover:scale-105'">
                                    <div class="flex justify-center mb-2">
                                        <?php for($j = 0; $j < $i; $j++): ?>
                                            <div class="w-5 h-7 sm:w-6 sm:h-8 rounded shadow-md <?php echo e($j > 0 ? '-ml-2' : ''); ?> transform <?php echo e($j % 2 === 0 ? 'rotate-3' : '-rotate-3'); ?> transition-all"
                                                 :class="cantidad == '<?php echo e($i); ?>' 
                                                     ? 'bg-gradient-to-br from-green-300 to-green-500' 
                                                     : 'bg-gradient-to-br from-yellow-300 to-orange-400'"></div>
                                        <?php endfor; ?>
                                    </div>
                                    <span class="text-2xl sm:text-3xl font-black transition-colors"
                                          :class="cantidad == '<?php echo e($i); ?>' ? 'text-green-400' : 'text-white'"><?php echo e($i); ?></span>
                                    <p class="text-[9px] sm:text-[10px] uppercase transition-colors"
                                       :class="cantidad == '<?php echo e($i); ?>' ? 'text-green-300' : 'text-gray-400'"><?php echo e($i === 1 ? 'Cartón' : 'Cartones'); ?></p>
                                </div>
                            </label>
                        <?php endfor; ?>
                    </div>
                </div>

                <input type="hidden" name="apuesta" value="1">

                <div class="glass-effect rounded-xl p-3 sm:p-4 mb-6 bg-gradient-to-r from-yellow-500/10 to-orange-500/10">
                    <div class="grid grid-cols-3 gap-2 sm:gap-4 text-center">
                        <div>
                            <p class="text-[10px] sm:text-xs text-gray-400 uppercase tracking-wider">Precio</p>
                            <p class="text-lg sm:text-2xl font-black text-yellow-400">$<?php echo e(number_format($juegoActivo->precio_carton / 1000, 0)); ?>K</p>
                        </div>
                        <div>
                            <p class="text-[10px] sm:text-xs text-gray-400 uppercase tracking-wider">Total</p>
                            <p class="text-xl sm:text-3xl font-black text-yellow-400" id="total-pagar">$<?php echo e(number_format($juegoActivo->precio_carton / 1000, 0)); ?>K</p>
                        </div>
                        <div>
                            <p class="text-[10px] sm:text-xs text-gray-400">Ganancia</p>
                            <p class="text-base sm:text-xl font-bold text-green-400">$<?php echo e(number_format(($juegoActivo->acumulado + $juegoActivo->premio_bingo) / 1000, 0)); ?>K</p>
                        </div>
                    </div>
                </div>

                <p class="text-xs text-gray-500 mb-4 text-center">
                    💡 Podrás aumentar tu apuesta por cartón dentro del juego antes de iniciar el sorteo
                </p>

                <button type="submit" 
                        title="Comprar los cartones seleccionados e ir al juego"
                        aria-label="Comprar cartones y jugar"
                        class="w-full py-4 rounded-xl font-bold text-lg uppercase tracking-wider bg-gradient-to-r from-yellow-500 via-orange-500 to-yellow-500 text-gray-900 hover:from-yellow-400 hover:via-orange-400 hover:to-yellow-400 transition-all transform hover:scale-[1.02] active:scale-[0.98] shadow-lg shadow-yellow-500/30">
                    <span class="flex items-center justify-center gap-3">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"/>
                        </svg>
                        Comprar y Jugar
                    </span>
                </button>
            </form>

            <?php if($misCartones > 0): ?>
                <div class="mt-6 p-3 sm:p-4 rounded-xl bg-gradient-to-r from-green-500/20 to-emerald-500/20 border border-green-500/30">
                    <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-3">
                        <div>
                            <p class="text-sm text-green-400 font-semibold">🎫 Ya tienes <?php echo e($misCartones); ?> cartón<?php echo e($misCartones > 1 ? 'es' : ''); ?></p>
                            <p class="text-xs text-gray-400">Puedes entrar al juego directamente</p>
                        </div>
                        <a href="<?php echo e(route('bingo.jugar', $juegoActivo)); ?>" 
                           title="Entrar a jugar con tus cartones ya comprados"
                           aria-label="Ir al juego de bingo"
                           class="w-full sm:w-auto px-6 py-3 rounded-xl font-bold uppercase tracking-wider bg-gradient-to-r from-green-500 to-emerald-600 text-white hover:from-green-400 hover:to-emerald-500 transition-all transform hover:scale-105 active:scale-95 shadow-lg shadow-green-500/30 flex items-center justify-center gap-2">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.752 11.168l-3.197-2.132A1 1 0 0010 9.87v4.263a1 1 0 001.555.832l3.197-2.132a1 1 0 000-1.664z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            Ir al Juego
                        </a>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <div class="mt-6 text-center">
            <p class="text-xs text-gray-500 mb-2">Código del juego: <span class="text-yellow-400 font-mono"><?php echo e($juegoActivo->codigo); ?></span></p>
            <p class="text-xs text-gray-600">Estado: 
                <span class="inline-flex items-center gap-1">
                    <span class="w-2 h-2 rounded-full <?php echo e($juegoActivo->estado === 'esperando' ? 'bg-yellow-500 animate-pulse' : ($juegoActivo->estado === 'en_curso' ? 'bg-green-500 animate-pulse' : 'bg-gray-500')); ?>"></span>
                    <?php echo e(ucfirst(str_replace('_', ' ', $juegoActivo->estado))); ?>

                </span>
            </p>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('comprar-form');
        const totalEl = document.getElementById('total-pagar');
        const precioBase = <?php echo e($juegoActivo->precio_carton); ?>;
        
        function updateTotal() {
            const cantidad = parseInt(form.querySelector('input[name="cantidad"]:checked')?.value || 1);
            const total = cantidad * precioBase;
            totalEl.textContent = '$' + (total / 1000) + 'K';
        }
        
        form.querySelectorAll('input[name="cantidad"]').forEach(input => {
            input.addEventListener('change', updateTotal);
        });
        
        updateTotal();
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/arzabala/Documents/proyecto/bingo-electronico/resources/views/bingo/index.blade.php ENDPATH**/ ?>