import axios from 'axios';
window.axios = axios;

window.axios.defaults.headers.common['X-Requested-With'] = 'XMLHttpRequest';

import Echo from 'laravel-echo';
import Pusher from 'pusher-js';

window.Pusher = Pusher;

const pusherKey = import.meta.env.VITE_PUSHER_APP_KEY || window.PUSHER_CONFIG?.key;
const pusherCluster = import.meta.env.VITE_PUSHER_APP_CLUSTER || window.PUSHER_CONFIG?.cluster;

console.log('🔑 Pusher Key:', pusherKey ? '✅ ' + pusherKey.substring(0, 8) + '...' : '❌ No configurada');
console.log('🌍 Pusher Cluster:', pusherCluster || '❌ No configurado');

if (pusherKey && pusherCluster) {
    window.Echo = new Echo({
        broadcaster: 'pusher',
        key: pusherKey,
        cluster: pusherCluster,
        forceTLS: true
    });
    
    window.Echo.connector.pusher.connection.bind('connected', () => {
        console.log('✅ Pusher conectado exitosamente');
    });
    
    window.Echo.connector.pusher.connection.bind('error', (err) => {
        console.error('❌ Error de Pusher:', err);
    });
    
    console.log('✅ Echo/Pusher inicializado');
} else {
    console.error('❌ Pusher no configurado - Credenciales faltantes');
    console.log('Tip: Verifica VITE_PUSHER_APP_KEY y VITE_PUSHER_APP_CLUSTER en tu .env');
}
