<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class SorteoIniciado implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public int $juegoId;
    public string $estado;
    public string $iniciadoPor;

    public function __construct(int $juegoId, string $estado, string $iniciadoPor)
    {
        $this->juegoId = $juegoId;
        $this->estado = $estado;
        $this->iniciadoPor = $iniciadoPor;
    }

    public function broadcastOn(): array
    {
        return [
            new Channel('juego.' . $this->juegoId),
        ];
    }

    public function broadcastAs(): string
    {
        return 'sorteo.iniciado';
    }
}
