<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class JuegoReiniciado implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public int $juegoId;
    public string $mensaje;

    public function __construct(int $juegoId, string $mensaje = 'El moderador ha reiniciado el juego')
    {
        $this->juegoId = $juegoId;
        $this->mensaje = $mensaje;
    }

    public function broadcastOn(): Channel
    {
        return new Channel('juego.' . $this->juegoId);
    }

    public function broadcastAs(): string
    {
        return 'juego.reiniciado';
    }
}
