<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class JuegoActualizado implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public int $juegoId;
    public string $tipo;
    public float $acumulado;
    public float $premioLinea;
    public float $premioBingo;
    public int $totalCartones;
    public int $totalJugadores;
    public string $estado;
    public array $jugadores;
    public ?string $nuevoJugador;

    public function __construct(
        int $juegoId,
        string $tipo,
        float $acumulado,
        float $premioLinea,
        float $premioBingo,
        int $totalCartones,
        int $totalJugadores,
        string $estado,
        array $jugadores = [],
        ?string $nuevoJugador = null
    ) {
        $this->juegoId = $juegoId;
        $this->tipo = $tipo;
        $this->acumulado = $acumulado;
        $this->premioLinea = $premioLinea;
        $this->premioBingo = $premioBingo;
        $this->totalCartones = $totalCartones;
        $this->totalJugadores = $totalJugadores;
        $this->estado = $estado;
        $this->jugadores = $jugadores;
        $this->nuevoJugador = $nuevoJugador;
    }

    public function broadcastOn(): array
    {
        return [
            new Channel('juego.' . $this->juegoId),
        ];
    }

    public function broadcastAs(): string
    {
        return 'juego.actualizado';
    }
}
